<?php
// quote_print.php
// Beklenen değişkenler: $doc, $items, $company, $settings

$currencySymbol = (string)($doc['currency_symbol'] ?? '₺');

// KDV kırılımı (kalemlerden)
$vatBreakdown = [];
$subtotal = 0.0;
$vatTotal = 0.0;

foreach (($items ?? []) as $it) {
  $lineSub = (float)($it['line_subtotal'] ?? ((float)$it['qty'] * (float)$it['unit_price']));
  $lineVat = (float)($it['line_vat'] ?? ($lineSub * ((float)$it['vat_rate'] / 100)));
  $rateKey = number_format((float)($it['vat_rate'] ?? 0), 2, '.', '');

  $subtotal += $lineSub;
  $vatTotal += $lineVat;

  if (!isset($vatBreakdown[$rateKey])) $vatBreakdown[$rateKey] = 0.0;
  $vatBreakdown[$rateKey] += $lineVat;
}

// Eğer kargo "separate" ise toplam içine ekle (kalem olarak ise zaten items içinde olur)
$shipMode   = (string)($doc['shipping_mode'] ?? 'none');
$shipAmount = (float)($doc['shipping_amount'] ?? 0);
$shipVatRate = (float)($doc['shipping_vat_rate'] ?? ($settings['shipping_vat_rate'] ?? 20));

if ($shipMode === 'separate' && $shipAmount > 0) {
  $shipVat = $shipAmount * ($shipVatRate / 100);
  $subtotal += $shipAmount;
  $vatTotal += $shipVat;

  $rateKey = number_format($shipVatRate, 2, '.', '');
  if (!isset($vatBreakdown[$rateKey])) $vatBreakdown[$rateKey] = 0.0;
  $vatBreakdown[$rateKey] += $shipVat;
}

$grandTotal = (float)($doc['total'] ?? ($subtotal + $vatTotal));

// Dosya adı: "TKL-0001 - Musteri"
$fname = trim((string)($doc['doc_no'] ?? 'TEKLIF'));
if (!empty($doc['customer_name'])) $fname .= ' - '.trim((string)$doc['customer_name']);
$fname = preg_replace('/[\\\\\\/:"*?<>|]+/', '-', $fname);
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($fname) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <style>
    :root { --ink:#0f172a; --muted:#475569; --line:#e2e8f0; }
    body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial; color:var(--ink); margin:0; }
    .page { max-width: 900px; margin: 24px auto; padding: 0 18px; }
    .card { border:1px solid var(--line); border-radius:14px; padding:18px; }
    .row { display:flex; gap:16px; justify-content:space-between; align-items:flex-start; }
    .muted { color:var(--muted); font-size:12px; }
    h1 { margin:0; font-size:20px; letter-spacing:.2px; }
    h2 { margin:0; font-size:14px; }
    table { width:100%; border-collapse:collapse; margin-top:14px; }
    th, td { border-bottom:1px solid var(--line); padding:10px 8px; font-size:12.5px; vertical-align:top; }
    th { text-align:left; color:var(--muted); font-weight:600; font-size:11.5px; }
    .right { text-align:right; }
    .totals { margin-top:14px; display:flex; justify-content:flex-end; }
    .totbox { width: 320px; border:1px solid var(--line); border-radius:12px; padding:12px; }
    .totline { display:flex; justify-content:space-between; font-size:12.5px; margin:6px 0; }
    .grand { font-weight:800; font-size:14px; padding-top:8px; border-top:1px dashed var(--line); margin-top:8px; }
    .vatbox { margin-top:10px; border-top:1px dashed var(--line); padding-top:8px; }
    .printbar { display:flex; justify-content:flex-end; gap:10px; margin-top:12px; }
    @media print { .printbar { display:none; } .page { margin:0; padding:0; } .card { border:none; } }
  </style>
</head>
<body>
  <div class="page">
    <div class="card">
      <div class="row">
        <div>
          <h1>TEKLİF</h1>
          <div class="muted" style="margin-top:6px;">
            Teklif No: <strong><?= e((string)($doc['doc_no'] ?? '')) ?></strong><br>
            Tarih: <?= e((string)($doc['issue_date'] ?? '')) ?>
            <?php if (!empty($doc['due_date'])): ?> • Vade: <?= e((string)$doc['due_date']) ?><?php endif; ?>
          </div>
        </div>
        <div style="text-align:right;">
          <h2><?= e((string)($company['name'] ?? '')) ?></h2>
          <div class="muted" style="margin-top:6px; white-space:pre-line;">
            <?= e((string)($company['address'] ?? '')) ?>
          </div>
          <div class="muted" style="margin-top:6px;">
            <?= !empty($company['phone']) ? 'Tel: '.e((string)$company['phone']).'<br>' : '' ?>
            <?= !empty($company['email']) ? 'E-posta: '.e((string)$company['email']).'<br>' : '' ?>
          </div>
        </div>
      </div>

      <div style="margin-top:16px; display:flex; gap:14px;">
        <div style="flex:1; border:1px solid var(--line); border-radius:12px; padding:12px;">
          <div class="muted">Müşteri</div>
          <div style="font-weight:700; margin-top:4px;"><?= e((string)($doc['customer_name'] ?? '')) ?></div>
          <div class="muted" style="margin-top:6px; white-space:pre-line;">
            <?= e((string)($doc['customer_address'] ?? '')) ?>
          </div>
        </div>
      </div>

      <table>
        <thead>
          <tr>
            <th>Ürün/Hizmet</th>
            <th>Açıklama</th>
            <th class="right">Miktar</th>
            <th>Birim</th>
            <th class="right">Birim Fiyat</th>
            <th class="right">KDV %</th>
            <th class="right">Tutar</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach (($items ?? []) as $it): ?>
            <tr>
              <td><strong><?= e((string)$it['name']) ?></strong></td>
              <td><?= e((string)($it['description'] ?? '')) ?></td>
              <td class="right"><?= rtrim(rtrim(number_format((float)$it['qty'],3,',','.'),'0'),',') ?></td>
              <td><?= e((string)($it['unit'] ?? '')) ?></td>
              <td class="right"><?= e($currencySymbol) ?> <?= number_format((float)$it['unit_price'],2,',','.') ?></td>
              <td class="right"><?= number_format((float)$it['vat_rate'],2,',','.') ?></td>
              <td class="right"><strong><?= e($currencySymbol) ?> <?= number_format((float)$it['line_total'],2,',','.') ?></strong></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>

      <div class="totals">
        <div class="totbox">
          <div class="totline"><span class="muted">Ara toplam</span><span><strong><?= e($currencySymbol) ?> <?= number_format($subtotal,2,',','.') ?></strong></span></div>
          <div class="totline"><span class="muted">KDV</span><span><strong><?= e($currencySymbol) ?> <?= number_format($vatTotal,2,',','.') ?></strong></span></div>

          <?php if ($shipMode === 'separate' && $shipAmount > 0): ?>
            <div class="totline"><span class="muted">Kargo</span><span><strong><?= e($currencySymbol) ?> <?= number_format($shipAmount,2,',','.') ?></strong></span></div>
          <?php endif; ?>

          <div class="grand totline"><span>Genel toplam</span><span><?= e($currencySymbol) ?> <?= number_format($grandTotal,2,',','.') ?></span></div>

          <?php if (!empty($vatBreakdown)): ?>
            <div class="vatbox">
              <div class="muted" style="margin-bottom:6px;">KDV Kırılımı</div>
              <?php foreach ($vatBreakdown as $rate => $amt): ?>
                <div class="totline">
                  <span class="muted">%<?= number_format((float)$rate,2,',','.') ?> KDV</span>
                  <span><strong><?= e($currencySymbol) ?> <?= number_format((float)$amt,2,',','.') ?></strong></span>
                </div>
              <?php endforeach; ?>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <?php if (!empty($doc['notes'])): ?>
        <div style="margin-top:14px; border-top:1px dashed var(--line); padding-top:12px;">
          <div class="muted">Notlar</div>
          <div style="white-space:pre-line; font-size:12.5px; margin-top:6px;"><?= e((string)$doc['notes']) ?></div>
        </div>
      <?php endif; ?>

      <div class="printbar">
        <button onclick="window.print()" style="padding:10px 14px; border-radius:10px; border:1px solid var(--line); background:white; cursor:pointer;">
          Yazdır / PDF
        </button>
      </div>
    </div>
  </div>

  <script>
    // PDF kaydederken dosya adı ipucu (bazı tarayıcılarda işe yarar)
    document.title = <?= json_encode($fname, JSON_UNESCAPED_UNICODE) ?>;
  </script>
</body>
</html>
